<?php

/**
 * Product: sonnb - Stop Spam Here
 * Version: 1.2.3
 * Date: 27th Jan 2013
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * ********* Any action to public or redistribute must be authorized from author
 * ********* One copy is valid for one board only*********
 */
class sonnbStopSpamHere_Listener
{

    public static function load_class($class, array &$extend)
    {
        switch ($class)
        {
            case "XenForo_ControllerPublic_Forum":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Forum';
                break;
            case "XenForo_ControllerPublic_Thread":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Thread';
                break;
            case "XenForo_ControllerPublic_Conversation":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Conversation';
                break;
            case "XenForo_ControllerPublic_ProfilePost":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_ProfilePost';
                break;
            case "XenForo_ControllerPublic_Member":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Member';
                break;
            case "XenForo_ControllerPublic_Register":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Register';
                break;
            case "XenForo_ControllerPublic_Account":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Account';
                break;
            case "XenForo_ControllerPublic_Post":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_Post';
                break;
                
            case "XenForo_DataWriter_Discussion_Thread":
                $extend[] = 'sonnbStopSpamHere_DataWriter_Discussion_Thread';
                break;
            case "XenForo_DataWriter_DiscussionMessage_Post":
                $extend[] = 'sonnbStopSpamHere_DataWriter_DiscussionMessage_Post';
                break;
            case "XenForo_DataWriter_DiscussionMessage_ProfilePost":
                $extend[] = 'sonnbStopSpamHere_DataWriter_DiscussionMessage_ProfilePost';
                break;
            case "XenForo_DataWriter_User":
                $extend[] = 'sonnbStopSpamHere_DataWriter_User';
                break;
            case "XenForo_DataWriter_ProfilePostComment":
                $extend[] = 'sonnbStopSpamHere_DataWriter_ProfilePostComment';
                break;
            case "XenForo_DataWriter_ConversationMessage":
                $extend[] = 'sonnbStopSpamHere_DataWriter_ConversationMessage';
                break;
            case "XenForo_DataWriter_ConversationMaster":
                $extend[] = 'sonnbStopSpamHere_DataWriter_ConversationMaster';
                break;
                
            case "XenForo_ControllerPublic_InlineMod_Post":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_InlineMod_Post';
                break;
            case "XenForo_ControllerPublic_InlineMod_ProfilePost":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_InlineMod_ProfilePost';
                break;
            case "XenForo_ControllerPublic_InlineMod_Thread":
                $extend[] = 'sonnbStopSpamHere_ControllerPublic_InlineMod_Thread';
                break;
        }
    }
    
    public static function template_hook($hookName, &$contents, array $hookParams, XenForo_Template_Abstract $template)
    {
        $xenOptions = XenForo_Application::getOptions();
        $visitor = XenForo_Visitor::getInstance();
        
        switch ($hookName)
        {
        	case 'sonnb_stop_spam_register':
        		if ($xenOptions->sonnbStopSpamHere_registration &&
        				$xenOptions->sonnbStopSpamHere_registration_hiddenField)
        		{
        			$templateHook = $template->create('sonnbStopSpamHere_hiddenField');
        		
        			$rendered = $templateHook->render();
        		
        			$contents .= $rendered;
        		}
        		break;
        	case 'post_private_controls':
        		if ($visitor->hasPermission('sonnbSSH', 'mark') && isset($hookParams['post']['message_state']) && 
        				$hookParams['post']['message_state'] == 'visible')
        		{
        			$templateHook = $template->create('sonnbStopSpamHere_post_markSpam', $hookParams);
        			
        			$rendered = $templateHook->render();
        			
        			$contents .= $rendered;
        		}
        		break;
        	case 'profile_post_private_controls':
        		if ($visitor->hasPermission('sonnbSSH', 'delete'))
        		{
        			$templateHook = $template->create('sonnbStopSpamHere_profilePost_markSpam', $hookParams);
        			
        			$rendered = $templateHook->render();
        			
        			$contents .= $rendered;
        		}
        		break;
        	case 'sonnb_stop_spam_thread_view_delete':
        	case 'sonnb_stop_spam_thread_list_delete':
        	case 'sonnb_stop_spam_profile_post_delete':
        		if ($visitor->hasPermission('sonnbSSH', 'delete'))
        		{
        			$templateHook = $template->create('sonnbStopSpamHere_deleteSpam', $hookParams);
        			
        			$rendered = $templateHook->render();
        			
        			$contents .= $rendered;
        		}
        		break;
        }
    }

    public static function templatePostRender($templateName, &$content, array &$containerData, XenForo_Template_Abstract $template)
    {
    	if (!$template instanceof XenForo_Template_Abstract)
    	{
    		return;
    	}
    	
        if ($templateName == 'option_list')
        {
        	$params = $template->getParams();
        	
            if (isset($params['group']['group_id']) && 
            		$params['group']['group_id'] == 'sonnbStopSpamHere')
            {
                $content = $template->create('sonnbStopSpamHere_optionTab', $params);
            }
        }
    }

    public static function renderNodes(XenForo_View $view, $fieldPrefix, array $preparedOption, $canEdit)
    {
        $preparedOption['formatParams'] = self::getNodeOptions(
                        $preparedOption['option_value']
        );

        return XenForo_ViewAdmin_Helper_Option::renderOptionTemplateInternal(
                        'sonnbStopSpamHere_nodes', $view, $fieldPrefix, $preparedOption, $canEdit
        );
    }

    public static function getNodeOptions($selectedForum, $includeRoot = false)
    {
        $nodeModel = XenForo_Model_DataRegistry::create('XenForo_Model_Node');

        $options = array();

        foreach ($nodeModel->getAllNodes() AS $nodeId => $node)
        {
            $node['depth'] += (($includeRoot && $nodeId) ? 1 : 0);

            $options[$nodeId] = array(
                'value' => $nodeId,
                'label' => $node['title'],
                'selected' => in_array($nodeId, $selectedForum),
                'depth' => $node['depth'],
                'node_type_id' => $node['node_type_id']
            );
        }

        return $options;
    }
}